<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// Ambil daftar barang
$barang = $db->query("SELECT * FROM inventory_stok ORDER BY nama_barang ASC");
?>

<h2>Barang Masuk</h2>

<form method="post" action="../../process/inventory_process.php">
    <table class="table">
        <tr>
            <td>Barang</td>
            <td>
                <select name="barang_id" required>
                    <option value="">-- Pilih Barang --</option>
                    <?php while($b = $barang->fetch_assoc()): ?>
                        <option value="<?= $b['id']; ?>">
                            <?= $b['nama_barang']; ?> (Stok: <?= $b['stok']; ?>)
                        </option>
                    <?php endwhile; ?>
                </select>
            </td>
        </tr>
        <tr>
            <td>Jumlah Masuk</td>
            <td><input type="number" name="jumlah" min="1" required></td>
        </tr>
        <tr>
            <td>Keterangan</td>
            <td><input type="text" name="keterangan"></td>
        </tr>
        <tr>
            <td colspan="2">
                <button type="submit" name="aksi" value="masuk">Simpan</button>
            </td>
        </tr>
    </table>
</form>

<?php require_once '../../templates/footer.php'; ?>
